﻿var findAndReplace = {
    context: $(".v-findAndReplace"),
    translations: undefined,
    foundTranslations: undefined,
    datatable: undefined,
    initialize: function () {
        $(".v-languagesAutocomplete", this.context).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetQuestionnaireLanguagesForAutoComplete", "Questionnaire"),
            multipleSelection: true,
            updateCount: function (event, data) {
                if (data.itemCount > 0) {
                    $(".v-findContainer input, .v-findContainer .button", findAndReplace.context).prop("disabled", false).removeClass("disabled");
                }
                else {
                    $(".v-findContainer input, .v-findContainer .button, .v-replaceContainer input, .v-replaceContainer .button", findAndReplace.context).prop("disabled", true).addClass("disabled");
                    $(".v-replaceContainer input, .v-findContainer input", findAndReplace.context).val("");
                }
            }
        });
    },
    bindEvents: function () {
        this.context.on("change", ".v-findValue", function () {
            $(".v-replaceContainer input, .v-replaceContainer .button", findAndReplace.context).prop("disabled", true).addClass("disabled");
            $(".v-replaceContainer input", findAndReplace.context).val("");
        });

        this.context.on("click", ".h-findAll:not(.disabled)", function () {
            if ($(".v-findValue", findAndReplace.context).val()) {
                if (!findAndReplace.translations) {
                    a4.callServerMethod(a4.getSurveyAction("GetTranslations", "Translate"), {},
                        function (result) {
                            findAndReplace.translations = result.translations;
                            findAndReplace.findTexts();
                        });
                }
                else {
                    findAndReplace.findTexts();
                }
            }
        });

        this.context.on("click", ".h-replaceInSelection:not(.disabled)", function () {
            var selectedRows = findAndReplace.datatable.a4datatable("getSelectedItems");

            if (selectedRows && selectedRows.length > 0) {
                findAndReplace.replaceTexts(selectedRows);
            }
        });

        this.context.on("click", ".h-replaceAll:not(.disabled)", function () {
            findAndReplace.replaceTexts();
        });

        this.context.on("click", ".h-cancelChanges:not(.disabled)", function () {
            findAndReplace.cancelChanges();
        });

        this.context.on("click", ".h-saveChanges:not(.disabled)", function () {
            findAndReplace.saveChanges();
        });

        this.context.on("click", ".h-toggleAdvancedOptions", function () {
            $(this).find(".fa").toggleClass("fa-caret-down fa-caret-right");
            $(".v-advancedOptions", this.context).toggle();
        });
    },
    findTexts: function () {
        var searchValue = findAndReplace.getSearchRegex();
        var languages = $(".v-languagesAutocomplete", findAndReplace.context).a4autocomplete("getValue");
        var searchQuestions = $(".v-searchQuestions", findAndReplace.context).is(":checked");
        var searchMessages = $(".v-searchMessages", findAndReplace.context).is(":checked");
        var searchThemes = $(".v-searchThemes", findAndReplace.context).is(":checked");

        var pageLength = 20; 

        if (this.datatable) {
            pageLength = this.datatable.a4datatable("getPageLength");
            this.datatable.a4datatable("destroy");
            this.datatable = null;
        }

        if (searchValue && languages && languages.length > 0) {
            findAndReplace.foundTranslations = _.filter(findAndReplace.translations, function (t) {
                if ((searchQuestions && t.Item != "MESSAGES_&_ERRORS" && t.Item != "LOOK_&_FEEL") || (searchMessages && t.Item == "MESSAGES_&_ERRORS") || (searchThemes && t.Item == "LOOK_&_FEEL")) {
                    return _.some(languages, function (l) {
                        return t[l.Value] && t[l.Value].match(searchValue);
                    });
                }

                return false;
            });

            var columns = [{ "Name": "Item", "Title": resources.Item, "Data": "ItemLabel", "Width": "10%" },
                                { "Name": "Property", "Title": resources.Property, "Data": "PropertyLabel", "Width": "14%" },
                                 { "Name": "Id", "Title": resources.PropertyId, "Data": "Id", "Width": "8%" }];

            var languageColumnWidth = 68 / languages.length;

            _.each(languages, function (l) {
                columns.push({ "Name": l.Value, "Title": l.Label, "Data": l.Value, "Class": "v-text" + l.Value, "Width": languageColumnWidth + "%" });
            });

            searchValue = findAndReplace.getSearchRegex(true); //Escape html for replacing

            this.datatable = $(".h-resultsTable", this.context).a4datatable({
                height: "full",
                serverSide: false,
                data: findAndReplace.foundTranslations,
                displaySearchBox: false,
                allowRowSelection: true,
                columns: columns,
                displayLength: pageLength,
                rowBeforeCreated: function (event, data) {
                    _.each(languages, function (l) {
                        var text = a4.escapeHtml(data.data[l.Value]).replace(searchValue, "<b>$&</b>");
                        $(".v-text" + l.Value, data.row).html(text);
                    });
                },
                selectRow: function (event, data) {
                    $(".v-replaceContainer .h-replaceInSelection", findAndReplace.context).prop("disabled", data.selectedRows.length == 0).toggleClass("disabled", data.selectedRows.length == 0);
                },

                selectAll: function (event, data) {
                        $(".v-replaceContainer .h-replaceInSelection", findAndReplace.context).prop("disabled", data.selectedRows.length == 0).toggleClass("disabled", data.selectedRows.length == 0);
                }
            });

            if (findAndReplace.foundTranslations && findAndReplace.foundTranslations.length > 0) {
                $(".v-replaceContainer input, .v-replaceContainer .h-replaceAll", findAndReplace.context).prop("disabled", false).removeClass("disabled");
            }
        }
    },
    replaceTexts: function (rows) {
        var replaceValue = $(".v-replaceValue", findAndReplace.context).val() || "";

        if (replaceValue) {
            var searchValue = findAndReplace.getSearchRegex();
            var languages = _.pluck($(".v-languagesAutocomplete", findAndReplace.context).a4autocomplete("getValue"), "Value");

            if (!rows) {
                _.each(findAndReplace.foundTranslations, function (translation) {
                    _.each(languages, function (l) {
                        if (translation[l]) {
                            translation[l] = translation[l].replace(searchValue, replaceValue);
                            translation["Updated"] = true;
                        }
                    });
                });
            }
            else {
                _.each(rows, function (row) {
                    var translation = _.findWhere(findAndReplace.foundTranslations, row);

                    _.each(languages, function (l) {
                        if (translation[l]) {
                            translation[l] = translation[l].replace(searchValue, replaceValue);
                            translation["Updated"] = true;
                        }
                    });
                });
            }

            $(".v-findValue", findAndReplace.context).val(replaceValue);
            $(".v-replaceValue", findAndReplace.context).val("");

            findAndReplace.findTexts();
        }
    },
    saveChanges: function () {
        var updatedTranslations = _.map(_.where(findAndReplace.translations, { Updated: true }), function (t) { return _.omit(t, ["Updated", "PropertyLabel", "ItemLabel"]); });

        if (updatedTranslations.length > 0) {
            $(".h-cancelChanges, .h-saveChanges", findAndReplace.context).addClass("disabled");

            a4.callServerMethod(a4.getSurveyAction("UpdateTranslations", "Translate"), { translations: a4.encodeHtml(JSON.stringify(updatedTranslations)) }, function (result) {
                a4.showSuccessMessage(resources.SuccessMessage, 2000);

                findAndReplace.translations = _.map(findAndReplace.translations, function (t) { return _.omit(t, "Updated"); });

                $(".h-cancelChanges, .h-saveChanges", findAndReplace.context).removeClass("disabled");
            });
        }
    },
    cancelChanges: function () {
        window.location = window.location;
    },
    getSearchRegex: function (escapeHtml) {
        var valueToFind = $(".v-findValue", findAndReplace.context).val() || "";
        var caseSensitive = $(".v-caseSensitive", findAndReplace.context).is(":checked");
        var wholeWord = $(".v-wholeWord", findAndReplace.context).is(":checked");
        var regex = null;

        if (valueToFind) {
            if (escapeHtml) {
                valueToFind = a4.escapeHtml(valueToFind);
            }

            var pattern = valueToFind.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
            var flags = "g";

            if (!caseSensitive) {
                flags += "i";
            }

            if (wholeWord) {
                pattern = "\\b" + pattern + "\\b";
            }

            regex = new RegExp(pattern, flags)
        }

        return regex;
    }
}

$(document).ready(function () {
    if (findAndReplace.context.length > 0) {
        findAndReplace.initialize();
        findAndReplace.bindEvents();
    }
});

window.onbeforeunload = function (e) {
    e = e || window.event;

    if (_.some(findAndReplace.translations, function (t) { return t.Updated })) {
        // For IE and Firefox
        if (e) {
            e.returnValue = resources.UnsavedChanges;
        }
        // For Safari
        return resources.UnsavedChanges;
    }
};